% ex5_2.m
% Information matrix
% Example 5.2; Fig. 5.2
%
mx0=0;    % initial value of x0
Pxx=4;    % initial variances
Paa=4;
Pbb=4;
q=0.36;
r=0.25;
M=1000;
N=250;
t=0:N;
a=0.9;
b=1;
w=sqrt(q)*randn(M,N);
x=zeros(M,N+1);
u=2*randn(1,N+1);
% u=randn(1,N+1);
for j=1:M
x(j,1)=mx0;
    for i=1:N
        x(j,i+1)=a*x(j,i) + b*u(1,i) + w(j,i);
    end
end 
mx=mean(x);
cov11=zeros(1,N+1);
for i=1:N+1
    cov11(1,i)=x(:,i)'*x(:,i)/M;
end
D22=zeros(2,2,N);
D21=zeros(2,1,N);
D32=zeros(1,2,N);
%%% Information matrix  p.90
D11=a*a/q;
D21(1,1,:)=(2*a*mx(1:N)+b*u(1:N)-mx(2:N+1))/q;
D21(2,1,:)=a*u(1:N)/q;
D31=-a/q; D13=D31;
D22(1,1,:)=cov11(1:N)/q;
D22(1,2,:)=mx(1:N).*u(1:N)/q;
D22(2,1,:)=D22(1,2,:);
D22(2,2,:)=u(1:N).*u(1:N)/q;
D32(1,1,:)=-mx(1:N)/q;
D32(1,2,:)=-u(1:N)/q;
D33=1/q;

J0=zeros(3,3,N+1);      % J_{t/t-1}
Jxx=zeros(1,1,N+1);
Jthx=zeros(2,1,N+1);    % th=[a b]^{T}
Jxth=zeros(1,2,N+1);
Jthth=zeros(2,2,N+1);
CC=zeros(3,3,N+1);      % the inverse of JJ
J0(:,:,1)=[1/Pxx 0 0;   % initial covariance
    0  1/Paa  0;
    0  0  1/Pbb];
Kt=[1/r 0 0;
    0  0  0;
    0 0 0];
for i=1:N
Jxx(:,:,i)=J0(1,1,i) + 1/r;
Jxth(:,:,i)=J0(1,2:3,i);      % th=[a b]^T
Jthx(:,:,i)=Jxth(:,:,i)';
Jthth(:,:,i)=J0(2:3,2:3,i);
Del=Jxx(1,1,i)+D11;
Dt21=Jthx(:,:,i)+D21(:,:,i);
J0(1,1,i+1)=D33-D31*inv(Del)*D13;
J0(1,2:3,i+1)=D32(:,:,i)-D31*inv(Del)*Dt21';
J0(2:3,1,i+1)=J0(1,2:3,i+1)';
temp=Jthth(:,:,i)+D22(:,:,i);
J0(2:3,2:3,i+1)=temp-Dt21*inv(Del)*Dt21';
JJ=[Jxx(:,:,i) Jxth(:,:,i);
    Jthx(:,:,i) Jthth(:,:,i)];
CC(:,:,i)=inv(JJ);
end
CC(:,:,N+1)=inv(J0(:,:,N+1)+Kt);
V1=zeros(1,N+1);
V2=zeros(1,N+1);
V3=zeros(1,N+1);
for i=1:N+1
V1(1,i)=CC(1,1,i);
V2(1,i)=CC(2,2,i);
V3(1,i)=CC(3,3,i);
end

figure(1)
semilogy(t,V1,'b',t,V2,'r-',t,V3,'g','LineWidth',1.5)
grid
xlabel('Number of steps  t')
title('Fig. 5.2: Cramer Lower Bounds')
legend('V^{xx}_{t}','V^{aa}_t','V^{bb}_t')
hold on
